/**
 * @file cmd_help.h
 *
 * @brief Autogenerated interactive CLI help
 *
 * This file is part of the bladeRF project
 *
 * Copyright (C) 2014-2019 Nuand LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * WARNING: THIS FILE IS AUTOMATICALLY GENERATED BY GENERATE.BASH.
 * Any manual modifications to this file will be overwritten!
 * To edit the content of help strings, please edit interactive-help.md
 *
 * Last generated: Thu Jan 17 20:55:32 EST 2019 by rtucker@rho
 */

#ifndef BLADERF_CLI_DOC_CMD_HELP_H__
#define BLADERF_CLI_DOC_CMD_HELP_H__


#define CLI_CMD_HELPTEXT_calibrate \
  "Usage: calibrate <operation> [options]\n" \
  "\n" \
  "Perform the specified transceiver calibration operation.\n" \
  "\n" \
  "Available operations:\n" \
  "\n" \
  "-   LMS internal DC offset auto-calibrations\n" \
  "\n" \
  "    -   calibrate lms [show]\n" \
  "    -   calibrate lms tuning [value]\n" \
  "    -   calibrate lms txlpf [<I filter> <Q filter>]\n" \
  "    -   calibrate lms rxlpf [<I filter> <Q filter>]\n" \
  "    -   calibrate lms rxvga2 [<DC ref> <I1> <Q1> <I2> <Q2>]\n" \
  "\n" \
  "    Perform the specified auto-calibration, or all of them if none are\n" \
  "    provided. When values are provided, these are used instead of the\n" \
  "    results of the auto-calibration procedure. Use lms show to read\n" \
  "    and print the current LMS calibration values.\n" \
  "\n" \
  "    For rxvga2, I1 and Q1 are the Stage 1 I and Q components\n" \
  "    respectively, and I2 and Q2 are the Stage 2 I and Q components.\n" \
  "\n" \
  "-   RX and TX I/Q DC offset correction parameter calibration\n" \
  "\n" \
  "    -   calibrate dc <rx|tx> [<I> <Q>]\n" \
  "    -   calibrate dc <rxtx>\n" \
  "\n" \
  "    Calibrate the DC offset correction parameters for the current\n" \
  "    frequency and gain settings. If a I/Q values are provided, they\n" \
  "    are applied directly. cal rxtx is shorthand for cal rx followed by\n" \
  "    cal tx.\n" \
  "\n" \
  "-   RX and TX I/Q balance correction parameter calibration\n" \
  "\n" \
  "    -   calibrate iq <rx|tx> <gain|phase> <value>\n" \
  "\n" \
  "    Set the specified IQ gain or phase balance parameters.\n" \
  "\n" \
  "-   Generate RX or TX I/Q DC correction parameter tables\n" \
  "\n" \
  "    -   calibrate table dc <rx|tx> [<f_min> <f_max> [f_inc]]\n" \
  "\n" \
  "    Generate and write an I/Q correction parameter table to the\n" \
  "    current working directory, in a file named\n" \
  "    <serial>_dc_<rx|tx>.tbl. f_min and f_max are min and max\n" \
  "    frequencies to include in the table. f_inc is the frequency\n" \
  "    increment.\n" \
  "\n" \
  "    By default, tables are generated over the entire frequency range,\n" \
  "    in 10 MHz steps.\n" \
  "\n" \
  "-   Generate RX or TX I/Q DC correction parameter tables for AGC Look\n" \
  "    Up Table\n" \
  "\n" \
  "    -   calibrate table agc <rx|tx> [<f_min> <f_max> [f_inc]]\n" \
  "\n" \
  "    Similar usage as calibrate table dc except the call will set gains\n" \
  "    to the AGC's base gain value before running calibrate table dc.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_clear \
  "Usage: clear\n" \
  "\n" \
  "Clears the screen.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_echo \
  "Usage: echo [arg 1] [arg 2] ... [arg n]\n" \
  "\n" \
  "Echo each argument on a new line.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_erase \
  "Usage: erase <offset> <count>\n" \
  "\n" \
  "Erase specified erase blocks SPI flash.\n" \
  "\n" \
  "-   <offset> - Erase block offset\n" \
  "-   <count> - Number of erase blocks to erase\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_flash_backup \
  "Usage: flash_backup <file> (<type> | <address> <length>)\n" \
  "\n" \
  "Back up flash data to the specified file. This command takes either\n" \
  "two or four arguments. The two-argument invocation is generally\n" \
  "recommended for non-development use.\n" \
  "\n" \
  "Parameters:\n" \
  "\n" \
  "-   <type> - Type of backup.\n" \
  "\n" \
  "    This selects the appropriate address and length values based upon\n" \
  "    the selected type.\n" \
  "\n" \
  "    Valid options are:\n" \
  "\n" \
  "             Option Description\n" \
  "      ------------- ----------------------------------------------------------\n" \
  "                cal Calibration data\n" \
  "                 fw Firmware\n" \
  "             fpga40 Metadata and bitstream for 40 kLE FPGA\n" \
  "            fpga115 Metadata and bitstream for 115 kLE FPGA\n" \
  "             fpgaA4 Metadata and bitstream for 49 kLE (A4) FPGA\n" \
  "             fpgaA5 Metadata and bitstream for 77 kLE (A5) FPGA\n" \
  "             fpgaA9 Metadata and bitstream for 301 kLE (A9) FPGA\n" \
  "\n" \
  "-   <address> - Address of data to back up. Must be erase\n" \
  "    block-aligned.\n" \
  "-   <len> - Length of region to back up. Must be erase block-aligned.\n" \
  "\n" \
  "Note: When an address and length are provided, the image type will\n" \
  "default to raw.\n" \
  "\n" \
  "Examples:\n" \
  "\n" \
  "-   flash_backup cal.bin cal\n" \
  "\n" \
  "    Backs up the calibration data region.\n" \
  "\n" \
  "-   flash_backup cal_raw.bin 0x30000 0x10000\n" \
  "\n" \
  "    Backs up the calibration region as a raw data image.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_flash_image \
  "Usage: flash_image <image> [output options]\n" \
  "\n" \
  "Print a flash image's metadata or create a new flash image. When\n" \
  "provided with the name of a flash image file as the only argument,\n" \
  "this command will print the metadata contents of the image.\n" \
  "\n" \
  "The following options may be used to create a new flash image.\n" \
  "\n" \
  "-   data=<file>\n" \
  "\n" \
  "    File to containing data to store in the image.\n" \
  "\n" \
  "-   address=<addr>\n" \
  "\n" \
  "    Flash address. The default depends upon type parameter.\n" \
  "\n" \
  "-   type=<type>\n" \
  "\n" \
  "    Type of flash image. Defaults to raw.\n" \
  "\n" \
  "    Valid options are:\n" \
  "\n" \
  "      ------------------------------------------------------------------------\n" \
  "             Option Description\n" \
  "      ------------- ----------------------------------------------------------\n" \
  "                cal Calibration data\n" \
  "\n" \
  "                 fw Firmware\n" \
  "\n" \
  "             fpga40 Metadata and bitstream for 40 kLE FPGA\n" \
  "\n" \
  "            fpga115 Metadata and bitstream for 115 kLE FPGA\n" \
  "\n" \
  "             fpgaA4 Metadata and bitstream for 49 kLE (A4) FPGA\n" \
  "\n" \
  "             fpgaA9 Metadata and bitstream for 301 kLE (A9) FPGA\n" \
  "\n" \
  "                raw Raw data. The address and length parameters must be\n" \
  "                    provided if this type is selected.\n" \
  "      ------------------------------------------------------------------------\n" \
  "\n" \
  "-   serial=<serial>\n" \
  "\n" \
  "    Serial # to store in image. Defaults to zeros.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_flash_init_cal \
  "Usage: flash_init_cal <fpga_size> <vctcxo_trim> [<output_file>]\n" \
  "\n" \
  "Create and write a new calibration data region to the currently opened\n" \
  "device, or to a file. Be sure to back up calibration data prior to\n" \
  "running this command. (See the flash_backup command.)\n" \
  "\n" \
  "-   <fpga_size>\n" \
  "\n" \
  "    Either 40 or 115, depending on the device model.\n" \
  "\n" \
  "-   <vctcxo_trim>\n" \
  "\n" \
  "    VCTCXO/DAC trim value (0x0-0xffff)\n" \
  "\n" \
  "-   <output_file>\n" \
  "\n" \
  "    File to write calibration data to. When this argument is provided,\n" \
  "    no data will be written to the device's flash.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_flash_restore \
  "Usage: flash_restore <file> [<address> <length>]\n" \
  "\n" \
  "Restore flash data from a file, optionally overriding values in the\n" \
  "image metadata.\n" \
  "\n" \
  "-   <address>\n" \
  "\n" \
  "    Defaults to the address specified in the provided flash image\n" \
  "    file.\n" \
  "\n" \
  "-   <length>\n" \
  "\n" \
  "    Defaults to length of the data in the provided image file.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_fw_log \
  "Usage: fw_log [filename]\n" \
  "\n" \
  "Read the contents of the device's firmware log and write it to the\n" \
  "specified file. If no filename is specified, the log content is\n" \
  "written to stdout.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_generate \
  "Usage: generate <filename> [parameters] <signal_type>\n" \
  "\n" \
  "\n" \
  "Configuration parameters take the form param=value, and may be\n" \
  "specified in a single or multiple rx config invocations. Below is a\n" \
  "list of available parameters.\n" \
  "\n" \
  "  ---------------------------------------------------------------------------\n" \
  "          Parameter Description\n" \
  "  ----------------- ---------------------------------------------------------\n" \
  "                  n Number of samples to generate. 0 = unlimited.\n" \
  "\n" \
  "                mag Magnitude of signal [-mag, mag]. Default is 2047\n" \
  "\n" \
  "             format Output file format. One of the following:\n" \
  "\n" \
  "                    csv: CSV of SC16 Q11 samples (default)\n" \
  "\n" \
  "                    bin: Raw SC16 Q11 DAC samples\n" \
  "\n" \
  "\n" \
  "Generates signal for use with tx command. Signal types include:\n" \
  "\n" \
  "-   cw <period>\n" \
  "\n" \
  "    Generate a complex tone with a period relative to system sampling rate\n" \
  "\n" \
  "    period indicates the number of samples between 2*M_PI. For example, cw of 4 would\n" \
  "    generate a complex tone at +4/F_s. With a sampling rate of 20MSPS, the complex\n" \
  "    tone would be generated at +5MHz. A negative period indicates negative frequency.\n" \
  "\n" \
  "-   prn\n" \
  "\n" \
  "    Generates pseudorandom noise" \
  "\n" \
  "\n" \
  "Examples:\n" \
  "\n" \
  "-   To generate a CSV for a complex tone at -F_s/4 with a full scale swing of -500 to 500:\n" \
  "\n" \
  "    generate output.csv format=csv mag=500 cw 4\n" \
  "\n" \
  "\n" \
  "-   To generate 10,000,000 samples of PRN:\n" \
  "\n" \
  "    generate output.csv format=csv n=10e6 prn\n" \
  "\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_help \
  "Usage: help [<command>]\n" \
  "\n" \
  "Provides extended help, like this, on any command.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_info \
  "Usage: info\n" \
  "\n" \
  "Prints the following information about an opened device:\n" \
  "\n" \
  "-   Serial number\n" \
  "-   VCTCXO DAC calibration value\n" \
  "-   FPGA size\n" \
  "-   Whether or not the FPGA is loaded\n" \
  "-   USB bus, address, and speed\n" \
  "-   Backend (Denotes which device interface code is being used.)\n" \
  "-   Instance number\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_jump_to_boot \
  "Usage: jump_to_boot\n" \
  "\n" \
  "Clear out a FW signature word in flash and jump to FX3 bootloader.\n" \
  "\n" \
  "The device will continue to boot into the FX3 bootloader across power\n" \
  "cycles until new firmware is written to the device.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_load \
  "Usage: load <fpga|fx3> <filename>\n" \
  "\n" \
  "Load an FPGA bitstream or program the FX3's SPI flash.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_xb \
  "Usage: xb <board_model> <subcommand> [parameters]\n" \
  "\n" \
  "Enable or configure an expansion board.\n" \
  "\n" \
  "Valid values for board_model:\n" \
  "\n" \
  "-   100\n" \
  "\n" \
  "    XB-100 GPIO expansion board\n" \
  "\n" \
  "-   200\n" \
  "\n" \
  "    XB-200 LF/MF/HF/VHF transverter expansion board\n" \
  "\n" \
  "-   300\n" \
  "\n" \
  "    XB-300 amplifier board\n" \
  "\n" \
  "Common subcommands:\n" \
  "\n" \
  "-   enable\n" \
  "\n" \
  "    Enable the XB-100, XB-200, or XB-300 expansion board.\n" \
  "\n" \
  "XB-200 subcommands:\n" \
  "\n" \
  "-   filter [rx|tx] [50|144|222|custom|auto_1db|auto_3db]\n" \
  "\n" \
  "    Selects the specified RX or TX filter on the XB-200 board. Below\n" \
  "    are descriptions of each of the filter options.\n" \
  "\n" \
  "    -   50\n" \
  "\n" \
  "            Select the 50-54 MHz (6 meter band) filter.\n" \
  "\n" \
  "    -   144\n" \
  "\n" \
  "            Select the 144-148 MHz (2 meter band) filter.\n" \
  "\n" \
  "    -   222\n" \
  "\n" \
  "            Select the 222-225 MHz (1.25 meter band) filter. Realistically,\n" \
  "            this filter option is actually slightly wider, covering\n" \
  "            206 MHz - 235 MHz.\n" \
  "\n" \
  "    -   custom\n" \
  "\n" \
  "            Selects the custom filter path. The user should connect a filter\n" \
  "            along the corresponding FILT and FILT-ANT connections when using\n" \
  "            this option.  Alternatively one may jumper the FILT and FILT-ANT\n" \
  "            connections to achieve \"no filter\" for reception. (However, this is\n" \
  "            _highly_ discouraged for transmissions.)\n" \
  "\n" \
  "    -   auto_1db\n" \
  "\n" \
  "            Automatically selects one of the above choices based upon frequency\n" \
  "            and the filters' 1dB points. The custom path is used for cases\n" \
  "            that are not associated with the on-board filters.\n" \
  "\n" \
  "    -   auto_3db\n" \
  "\n" \
  "            Automatically selects one of the above choices based upon frequency\n" \
  "            and the filters' 3dB points. The custom path is used for cases\n" \
  "            that are not associated with the on-board filters.\n" \
  "\n" \
  "XB-300 subcommands:\n" \
  "\n" \
  "-   <pa|lna|aux> [on|off]\n" \
  "\n" \
  "    Enable or disable the power amplifier (PA), low-noise amplifier\n" \
  "    (lna) or auxillary LNA (aux). The current state if the specified\n" \
  "    device is printed if [on|off] is not specified.\n" \
  "\n" \
  "    Note: The auxillary path on the XB-300 is not populated with\n" \
  "    components by default; the aux control will have no effect upon\n" \
  "    the RX signal. This option is available for users to modify their\n" \
  "    board with custom hardware.\n" \
  "\n" \
  "-   <pwr>\n" \
  "\n" \
  "    Read the current Power Detect (PDET) voltage and compute the\n" \
  "    output power.\n" \
  "\n" \
  "-   trx <rx|tx>\n" \
  "\n" \
  "    The default XB-300 hardware configuration includes separate RX and\n" \
  "    TX paths. However, users wishing to use only a single antenna for\n" \
  "    TRX can do so via a modification to resistor population options on\n" \
  "    the XB-300 and use this command to switch between RX an TX\n" \
  "    operation. (See R8, R10, and R23 on the schematic.)\n" \
  "\n" \
  "Examples:\n" \
  "\n" \
  "-   xb 200 enable\n" \
  "\n" \
  "    Enables and configures the XB-200 transverter expansion board.\n" \
  "\n" \
  "-   xb 200 filter rx 144\n" \
  "\n" \
  "    Selects the 144-148 MHz receive filter on the XB-200 transverter\n" \
  "    expansion board.\n" \
  "\n" \
  "-   xb 300 enable\n" \
  "\n" \
  "    Enables and configures the use of GPIOs to interact with the\n" \
  "    XB-300. The PA and LNA will disabled by default.\n" \
  "\n" \
  "-   xb 300 lna on\n" \
  "\n" \
  "    Enables the RX LNA on the XB-300. LED D1 (green) is illuminated\n" \
  "    when the LNA is enabled, and off when it is disabled.\n" \
  "\n" \
  "-   xb 300 pa off\n" \
  "\n" \
  "    Disables the TX PA on the XB-300. LED D2 (blue) is illuminated\n" \
  "    when the PA is enabled, and off when it is disabled.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_mimo \
  "Usage: mimo [master | slave]\n" \
  "\n" \
  "Modify device MIMO operation.\n" \
  "\n" \
  "IMPORTANT: This command is deprecated and has been superseded by\n" \
  "\"print/set smb_mode\". For usage text, run: \"set smb_mode\"\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_open \
  "Usage: open [device identifiers]\n" \
  "\n" \
  "Open the specified device for use with successive commands. Any\n" \
  "previously opened device will be closed.\n" \
  "\n" \
  "The general form of the device identifier string is:\n" \
  "\n" \
  "<backend>:[device=<bus>:<addr>] [instance=<n>] [serial=<serial>]\n" \
  "\n" \
  "See the bladerf_open() documentation in libbladeRF for the complete\n" \
  "device specifier format.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_peek \
  "Usage: peek <rfic|pll|dac|lms|si> <address> [num_addresses]\n" \
  "\n" \
  "The peek command can read any of the devices hanging off the FPGA.\n" \
  "This includes the:\n" \
  "\n" \
  "-   bladeRF 1: LMS6002D transceiver, VCTCXO trim DAC, Si5338 clock\n" \
  "    generator\n" \
  "-   bladeRF 2: AD9361 transceiver, VCTCXO trim DAC, ADF4002 frequency\n" \
  "    synthesizer\n" \
  "\n" \
  "If num_addresses is supplied, the address is incremented by 1 and\n" \
  "another peek is performed for that many addresses.\n" \
  "\n" \
  "Valid Address Ranges:\n" \
  "\n" \
  "    Device Address Range\n" \
  "  -------- -------------------\n" \
  "      rfic 0 to 0x3F7 (1015)\n" \
  "       pll 0 to 3\n" \
  "       dac 0 to 255\n" \
  "       lms 0 to 127\n" \
  "        si 0 to 255\n" \
  "\n" \
  "Example:\n" \
  "\n" \
  "-   peek si ...\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_poke \
  "Usage: poke <rfic|pll|dac|lms|si> <address> <data>\n" \
  "\n" \
  "The poke command can write any of the devices hanging off the FPGA.\n" \
  "This includes the:\n" \
  "\n" \
  "-   bladeRF 1: LMS6002D transceiver, VCTCXO trim DAC, Si5338 clock\n" \
  "    generator\n" \
  "-   bladeRF 2: AD9361 transceiver, VCTCXO trim DAC, ADF4002 frequency\n" \
  "    synthesizer\n" \
  "\n" \
  "Valid Address Ranges:\n" \
  "\n" \
  "    Device Address Range\n" \
  "  -------- -------------------\n" \
  "      rfic 0 to 0x3F7 (1015)\n" \
  "       pll 0 to 3\n" \
  "       dac 0 to 255\n" \
  "       lms 0 to 127\n" \
  "        si 0 to 255\n" \
  "\n" \
  "Example:\n" \
  "\n" \
  "-   poke lms ...\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_print \
  "Usage: print [parameter]\n" \
  "\n" \
  "The print command takes a parameter to print. Available parameters are\n" \
  "listed below. If no parameter is specified, all parameters are\n" \
  "printed.\n" \
  "\n" \
  "Common parameters:\n" \
  "\n" \
  "       Parameter Description\n" \
  "  -------------- --------------------------------------------------------\n" \
  "       bandwidth Bandwidth settings\n" \
  "       frequency Frequency settings\n" \
  "             agc Automatic gain control\n" \
  "        loopback Loopback settings\n" \
  "          rx_mux FPGA RX FIFO input mux setting\n" \
  "            gain Gain settings\n" \
  "      samplerate Samplerate settings\n" \
  "         trimdac VCTCXO Trim DAC settings\n" \
  "     tuning_mode Tuning mode settings\n" \
  "         bitmode Sample bit width\n" \
  "        hardware Low-level hardware status\n" \
  "\n" \
  "BladeRF1-only parameters:\n" \
  "\n" \
  "       Parameter Description\n" \
  "  -------------- --------------------------------------------------------\n" \
  "            gpio FX3 <-> FPGA GPIO state\n" \
  "         lnagain RX LNA gain, in dB (deprecated)\n" \
  "          rxvga1 RXVGA1 gain, in dB (deprecated)\n" \
  "          rxvga2 RXVGA2 gain, in dB (deprecated)\n" \
  "          txvga1 TXVGA1 gain, in dB (deprecated)\n" \
  "          txvga2 TXVGA2 gain, in dB (deprecated)\n" \
  "        sampling External or internal sampling mode\n" \
  "        smb_mode SMB clock port mode of operation\n" \
  "    vctcxo_tamer Current VCTCXO tamer mode\n" \
  "         xb_gpio Expansion board GPIO values\n" \
  "     xb_gpio_dir Expansion board GPIO direction (1=output, 0=input)\n" \
  "\n" \
  "BladeRF2-only parameters:\n" \
  "\n" \
  "       Parameter Description\n" \
  "  -------------- --------------------------------------------------------\n" \
  "       clock_sel System clock selection\n" \
  "       clock_out Clock output selection\n" \
  "            rssi Received signal strength indication\n" \
  "       clock_ref ADF4002 chip status\n" \
  "      refin_freq ADF4002 reference clock frequency\n" \
  "         biastee Current bias-tee status\n" \
  "          filter RFIC FIR filter selection\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_probe \
  "Usage: probe [strict]\n" \
  "\n" \
  "Search for attached bladeRF device and print a list of results.\n" \
  "\n" \
  "Without specifying strict, the lack of any available devices is not\n" \
  "considered an error.\n" \
  "\n" \
  "When provided the optional strict argument, this command will treat\n" \
  "the situation where no devices are found as an error, causing scripts\n" \
  "or lists of commands provided via the -e command line argument to\n" \
  "terminate immediately.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_quit \
  "Usage: quit\n" \
  "\n" \
  "Exit the CLI.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_recover \
  "Usage: recover [<bus> <address> <firmware file>]\n" \
  "\n" \
  "Load firmware onto a device running in bootloader mode, or list all\n" \
  "devices currently in bootloader mode.\n" \
  "\n" \
  "With no arguments, this command lists the USB bus and address for\n" \
  "FX3-based devices running in bootloader mode.\n" \
  "\n" \
  "When provided a bus, address, and path to a firmware file, the\n" \
  "specified device will be loaded with and begin executing the provided\n" \
  "firmware.\n" \
  "\n" \
  "In most cases, after successfully loading firmware into the device's\n" \
  "RAM, users should open the device with the \"open\" command, and write\n" \
  "the firmware to flash via \"load fx3 <firmware file>\"\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_run \
  "Usage: run <script>\n" \
  "\n" \
  "Run the provided script.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_rx \
  "Usage: rx <start | stop | wait | config [param=val [param=val [...]]>\n" \
  "\n" \
  "Receive IQ samples and write them to the specified file. Reception is\n" \
  "controlled and configured by one of the following:\n" \
  "\n" \
  "  ----------------------------------------------------------------------------------\n" \
  "         Command Description\n" \
  "  -------------- -------------------------------------------------------------------\n" \
  "           start Start receiving samples\n" \
  "\n" \
  "            stop Stop receiving samples\n" \
  "\n" \
  "            wait Wait for sample transmission to complete, or until a specified\n" \
  "                 amount of time elapses\n" \
  "\n" \
  "          config Configure sample reception. If no parameters are provided, the\n" \
  "                 current parameters are printed.\n" \
  "  ----------------------------------------------------------------------------------\n" \
  "\n" \
  "Running rx without any additional commands is valid shorthand for\n" \
  "rx config.\n" \
  "\n" \
  "The wait command takes an optional timeout parameter. This parameter\n" \
  "defaults to units of milliseconds (ms). The timeout unit may be\n" \
  "specified using the ms or s suffixes. If this parameter is not\n" \
  "provided, the command will wait until the reception completes or\n" \
  "Ctrl-C is pressed.\n" \
  "\n" \
  "Configuration parameters take the form param=value, and may be\n" \
  "specified in a single or multiple rx config invocations. Below is a\n" \
  "list of available parameters.\n" \
  "\n" \
  "  ---------------------------------------------------------------------------\n" \
  "          Parameter Description\n" \
  "  ----------------- ---------------------------------------------------------\n" \
  "                  n Number of samples to receive. 0 = inf.\n" \
  "\n" \
  "               file Filename to write received samples to\n" \
  "\n" \
  "             format Output file format. One of the following:\n" \
  "\n" \
  "                    csv: CSV of SC16 Q11 samples\n" \
  "\n" \
  "                    bin: Raw SC16 Q11 DAC samples\n" \
  "\n" \
  "            samples Number of samples per buffer to use in the asynchronous\n" \
  "                    stream. Must be divisible by 1024 and >= 1024.\n" \
  "\n" \
  "            buffers Number of sample buffers to use in the asynchronous\n" \
  "                    stream. The min value is 4.\n" \
  "\n" \
  "              xfers Number of simultaneous transfers to allow the\n" \
  "                    asynchronous stream to use. This should be less than the\n" \
  "                    buffers parameter.\n" \
  "\n" \
  "            timeout Data stream timeout. With no suffix, the default unit is\n" \
  "                    ms. The default value is 1000 ms (1 s). Valid suffixes\n" \
  "                    are ms and s.\n" \
  "\n" \
  "            channel Comma-delimited list of physical RF channels to use\n" \
  "  ---------------------------------------------------------------------------\n" \
  "\n" \
  "Example:\n" \
  "\n" \
  "-   rx config file=/tmp/data.bin format=bin n=10K\n" \
  "\n" \
  "    Receive (10240 = 10 * 1024) samples, writing them to /tmp/data.bin\n" \
  "    in the binary DAC format.\n" \
  "\n" \
  "-   rx config file=mimo.csv format=csv n=32768 channel=1,2\n" \
  "\n" \
  "    Receive 32768 samples from RX1 and RX2, outputting them to a file\n" \
  "    named mimo.csv, with four columns (RX1 I, RX1 Q, RX2 I, RX2 Q).\n" \
  "\n" \
  "Notes:\n" \
  "\n" \
  "-   The n, samples, buffers, and xfers parameters support the suffixes\n" \
  "    K, M, and G, which are integer powers of 1024.\n" \
  "-   An rx stop followed by an rx start will result in the samples file\n" \
  "    being truncated. If this is not desired, be sure to run rx config\n" \
  "    to set another file before restarting the rx stream.\n" \
  "-   For higher sample rates, it is advised that the binary output\n" \
  "    format be used, and the output file be written to RAM (e.g. /tmp,\n" \
  "    /dev/shm), if space allows. For larger captures at higher sample\n" \
  "    rates, consider using an SSD instead of a HDD.\n" \
  "-   The CSV format produces two columns per channel, with the first\n" \
  "    two columns corresponding to the I,Q pair for the first channel\n" \
  "    configured with the channel parameter; the next two columns\n" \
  "    corresponding to the I,Q of the second channel, and so on.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_trigger \
  "Usage: trigger [<trigger> <tx | rx> [<off slave master fire>]]\n" \
  "\n" \
  "If used without parameters, this command prints the state of all\n" \
  "triggers. When and and supplied, the specified trigger is printed.\n" \
  "\n" \
  "Below are the available options for :\n" \
  "\n" \
  "                Trigger Description\n" \
  "  --------------------- ------------------------------------------------------------------------------------------------\n" \
  "                  J71-4 Trigger signal is on mini_exp1 (bladeRF x40/x115, J71, pin 4).\n" \
  "                  J51-1 Trigger signal is on mini_exp1 (bladeRF xA4/xA5/xA9, J51, pin 1).\n" \
  "              Miniexp-1 Trigger signal is on mini_exp1, hardware-independent\n" \
  "\n" \
  "Note that all three of the above options map to the same logical port\n" \
  "on all devices (mini_exp[1]). Multiple options are provided for\n" \
  "reverse compatibility and clarity.\n" \
  "\n" \
  "The trigger is controlled and configured by providing the last\n" \
  "argument, which may be one of the following:\n" \
  "\n" \
  "           Command Description\n" \
  "  ---------------- -----------------------------------------------------------------------------\n" \
  "               off Clears fire request and disables trigger functionality.\n" \
  "             slave Configures trigger as slave, clears fire request, and arms the device.\n" \
  "            master Configures trigger as master, clears fire request, and arms the device.\n" \
  "              fire Sets fire request. Only applicable to the master.\n" \
  "\n" \
  "A trigger chain consists of a single or multiple bladeRF units and may\n" \
  "contain TX and RX modules. If multiple bladeRF units are used they\n" \
  "need to be connected via the signal specified by and a common ground.\n" \
  "\n" \
  "The following sequence of commands should be used to ensure proper\n" \
  "synchronization. It is assumed that all triggers are off initially.\n" \
  "\n" \
  "1.  Configure designated trigger master\n" \
  "\n" \
  "    IMPORTANT\n" \
  "\n" \
  "        Never configure two devices as trigger masters on a single chain.\n" \
  "        Contention on the same signal could damage the devices.\n" \
  "\n" \
  "2.  Configure all other devices as trigger slaves\n" \
  "\n" \
  "3.  Configure and start transmit or receive streams.\n" \
  "\n" \
  "        The operation will stall until the triggers fire. As such, sufficiently\n" \
  "        large timeouts should be used to allow the trigger signal to be emitted\n" \
  "        by the master and received by the slaves prior to libbladeRF returning\n" \
  "        BLADERF_ERR_TIMEOUT.\n" \
  "\n" \
  "4.  Set fire-request on master trigger\n" \
  "\n" \
  "        All devices will synchronously start transmitting or receiving data.\n" \
  "\n" \
  "5.  Finish the transmit and receive tasks as usual\n" \
  "\n" \
  "6.  Re-configure the master and slaves to clear fire requests and\n" \
  "    re-arm.\n" \
  "\n" \
  "        Steps 1 through 5 may be repeated as neccessary.\n" \
  "\n" \
  "7.  Disable triggering on all slaves\n" \
  "\n" \
  "8.  Disable triggering on master\n" \
  "\n" \
  "Notes:\n" \
  "\n" \
  "-   Synchronizing transmitters and receivers on a single chain will\n" \
  "    cause an offset of 11 samples between TX and RX; these samples\n" \
  "    should be discarded. This is caused by different processing\n" \
  "    pipeline lengths of TX and RX. This value might change if the FPGA\n" \
  "    code is updated in the future.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_tx \
  "Usage: tx <start | stop | wait | config [parameters]>\n" \
  "\n" \
  "Read IQ samples from the specified file and transmit them.\n" \
  "Transmission is controlled and configured by one of the following:\n" \
  "\n" \
  "  ----------------------------------------------------------------------------------------\n" \
  "          Command Description\n" \
  "  --------------- ------------------------------------------------------------------------\n" \
  "            start Start transmitting samples\n" \
  "\n" \
  "             stop Stop transmitting samples\n" \
  "\n" \
  "             wait Wait for sample transmission to complete, or until a specified amount of\n" \
  "                  time elapses\n" \
  "\n" \
  "           config Configure sample transmission. If no parameters are provided, the\n" \
  "                  current parameters are printed.\n" \
  "  ----------------------------------------------------------------------------------------\n" \
  "\n" \
  "Running tx without any additional commands is valid shorthand for\n" \
  "tx config.\n" \
  "\n" \
  "The wait command takes an optional timeout parameter. This parameter\n" \
  "defaults to units of milliseconds (ms). The timeout unit may be\n" \
  "specified using the ms or s suffixes. If this parameter is not\n" \
  "provided, the command will wait until the transmission completes or\n" \
  "Ctrl-C is pressed.\n" \
  "\n" \
  "Configuration parameters take the form param=value, and may be\n" \
  "specified in a single or multiple tx config invocations. Below is a\n" \
  "list of available parameters.\n" \
  "\n" \
  "  ---------------------------------------------------------------------------\n" \
  "          Parameter Description\n" \
  "  ----------------- ---------------------------------------------------------\n" \
  "               file Filename to read samples from\n" \
  "\n" \
  "             format Input file format. One of the following:\n" \
  "\n" \
  "                    csv: CSV of SC16 Q11 samples ([-2048, 2047])\n" \
  "\n" \
  "                    bin: Raw SC16 Q11 DAC samples ([-2048, 2047])\n" \
  "\n" \
  "             repeat The number of times the file contents should be\n" \
  "                    transmitted. 0 implies repeat until stopped.\n" \
  "\n" \
  "              delay The number of microseconds to delay between\n" \
  "                    retransmitting file contents. 0 implies no delay.\n" \
  "\n" \
  "            samples Number of samples per buffer to use in the asynchronous\n" \
  "                    stream. Must be divisible by 1024 and >= 1024.\n" \
  "\n" \
  "            buffers Number of sample buffers to use in the asynchronous\n" \
  "                    stream. The min value is 4.\n" \
  "\n" \
  "              xfers Number of simultaneous transfers to allow the\n" \
  "                    asynchronous stream to use. This should be < the buffers\n" \
  "                    parameter.\n" \
  "\n" \
  "            timeout Data stream timeout. With no suffix, the default unit is\n" \
  "                    ms. The default value is 1000 ms (1 s). Valid suffixes\n" \
  "                    are 'ms' and 's'.\n" \
  "\n" \
  "            channel Comma-delimited list of physical RF channels to use\n" \
  "  ---------------------------------------------------------------------------\n" \
  "\n" \
  "Example:\n" \
  "\n" \
  "-   tx config file=data.bin format=bin repeat=2 delay=250000\n" \
  "\n" \
  "    Transmitting the contents of data.bin two times, with a ~250ms\n" \
  "    delay between transmissions.\n" \
  "\n" \
  "-   tx config file=mimo.csv format=csv repeat=0 channel=1,2\n" \
  "\n" \
  "    Transmitting the contents of mimo.csv repeatedly, with the first\n" \
  "    channel in the file mapped to channel TX1 and the second channel\n" \
  "    mapped to TX2.\n" \
  "\n" \
  "Notes:\n" \
  "\n" \
  "-   The n, samples, buffers, and xfers parameters support the suffixes\n" \
  "    K, M, and G, which are integer powers of 1024.\n" \
  "-   For higher sample rates, it is advised that the input file be\n" \
  "    stored in RAM (e.g. /tmp, /dev/shm) or on an SSD, rather than a\n" \
  "    HDD.\n" \
  "-   The CSV format expects two columns per channel, with the first two\n" \
  "    columns corresponding to the I,Q pair for the first channel\n" \
  "    configured with the channel parameter; the next two columns\n" \
  "    corresponding to the I,Q of the second channel, and so on. For\n" \
  "    example, in the mimo.csv example above, -128,128,-256,256 would\n" \
  "    transmit (-128,128) on TX1 and (-256,256) on TX2.\n" \
  "-   When providing CSV data, this command will first convert it to a\n" \
  "    binary format, stored in a file in the current working directory.\n" \
  "    During this process, out-of-range values will be clamped.\n" \
  "-   When using a binary format, the user is responsible for ensuring\n" \
  "    that the provided data values are within the allowed range. This\n" \
  "    prerequisite alleviates the need for this program to perform range\n" \
  "    checks in time-sensitive callbacks.\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_set \
  "Usage: set <parameter> <arguments>\n" \
  "\n" \
  "The set command takes a parameter and an arbitrary number of arguments\n" \
  "for that particular parameter. In general, set <parameter> will\n" \
  "display more help for that parameter.\n" \
  "\n" \
  "Common parameters:\n" \
  "\n" \
  "       Parameter Description\n" \
  "  -------------- --------------------------------------------------------\n" \
  "       bandwidth Bandwidth settings\n" \
  "       frequency Frequency settings\n" \
  "             agc Automatic gain control\n" \
  "        loopback Loopback settings\n" \
  "          rx_mux FPGA RX FIFO input mux mode\n" \
  "            gain Gain settings\n" \
  "      samplerate Samplerate settings\n" \
  "         trimdac VCTCXO Trim DAC settings\n" \
  "     tuning_mode Tuning mode settings\n" \
  "         bitmode Sample bit width\n" \
  "\n" \
  "BladeRF1-only parameters:\n" \
  "\n" \
  "       Parameter Description\n" \
  "  -------------- --------------------------------------------------------\n" \
  "            gpio FX3 <-> FPGA GPIO state\n" \
  "         lnagain RX LNA gain, in dB. Values: 0, 3, 6 (deprecated)\n" \
  "          rxvga1 RXVGA1 gain, in dB. Range: [5, 30] (deprecated)\n" \
  "          rxvga2 RXVGA2 gain, in dB. Range: [0, 30] (deprecated)\n" \
  "          txvga1 TXVGA1 gain, in dB. Range: [-35, -4] (deprecated)\n" \
  "          txvga2 TXVGA2 gain, in dB. Range: [0, 25] (deprecated)\n" \
  "        sampling External or internal sampling mode\n" \
  "        smb_mode SMB clock port mode of operation\n" \
  "    vctcxo_tamer VCTCXO tamer mode. Options: Disabled, 1PPS, 10MHz\n" \
  "         xb_gpio Expansion board GPIO values\n" \
  "     xb_gpio_dir Expansion board GPIO direction (1=output, 0=input)\n" \
  "\n" \
  "BladeRF2-only parameters:\n" \
  "\n" \
  "       Parameter Description\n" \
  "  -------------- --------------------------------------------------------\n" \
  "       clock_sel System clock selection\n" \
  "       clock_out Clock output selection\n" \
  "            rssi Received signal strength indication\n" \
  "       clock_ref Enables (1) or disables (0) the ADF4002 chip\n" \
  "      refin_freq ADF4002 reference clock frequency\n" \
  "         biastee Enables or disables the bias tee on a given channel\n" \
  "          filter RFIC FIR filter selection\n" \
  "\n" \


#define CLI_CMD_HELPTEXT_version \
  "Usage: version\n" \
  "\n" \
  "Prints version information for host software and the current device.\n" \
  "\n" \

#endif // BLADERF_CLI_VERSION_H__
